#define RPWM 5
#define LPWM 6
#define REN 8
#define LEN 9
#define RFC 12
#define LFC 11
#define MAX 120

void setup() {
  Serial.begin(9600);
  pinMode(RPWM,OUTPUT);
  pinMode(LPWM,OUTPUT);
  pinMode(LEN,OUTPUT);
  pinMode(REN,OUTPUT);
  pinMode(RFC,INPUT);
  pinMode(LFC,INPUT);
  
  Serial.print("DIRECTION remake by Luis PARRA");
}

void loop() {
  // check stop
  if(digitalRead(LFC)==1){
    analogWrite(LPWM,0);
  }else if (digitalRead(RFC)==1){
    analogWrite(RPWM,0);
  }
  
  if (Serial.available()) {  // Vérifie si des données sont disponibles sur l'entrée série
    char ch = Serial.read();  // Lit la valeur en tant que flottant
    // convert ascii char to value
    int ovalue = (int)ch - 97;
    float value = (float)(ovalue - 12) / 25 * 200;
   
  

    if (value >= -96 && value <= 104) {  // Vérifie si la valeur est correcte 
      Serial.print(value);
    
      if (value < 0){      //GAUCHE
        digitalWrite(REN,HIGH);
        digitalWrite(LEN,HIGH);
        analogWrite(RPWM,0);
        if(digitalRead(LFC)==0){
          int speed = abs(value)+20;
          analogWrite(LPWM,speed);
        }else{
          analogWrite(LPWM,0);
        }
       }else{ analogWrite(LPWM,0); }
  
     if (value > 0){      //DROITE
       digitalWrite(REN,HIGH);
       digitalWrite(LEN,HIGH);
       analogWrite(LPWM,0);
       if(digitalRead(RFC)==0){
         int speed = abs(value)+20;
         analogWrite(RPWM,speed);
       }else{
        analogWrite(RPWM,0);
       }
      }else{ analogWrite(RPWM,0); }
      if(value == 0){ digitalWrite(LEN,LOW);digitalWrite(REN,LOW); }
    } else {
      //Serial.println("Valeur invalide. Veuillez entrer une valeur entre -1 et 0.");
    }
  }

}
