# PIP IMPORTS
import json, sys
# CUSTOM IMPORTS
from common import *
import relay, learn, direction

ACTIVE_COMMANDS = []
BASEDIR = os.path.dirname(os.path.abspath(__file__))
MAPPING = json.loads(open(os.path.join(BASEDIR, "config/mapping.json"), "r").read())
COMMANDS = json.loads(open(os.path.join(BASEDIR, "config/commands.json"), "r").read())

def INTERPRET_LAYER(ACTIVE_KEYS, LAYER, LAYER_ACTIVATION_KEY=None):
    NEW_ACTIVE_COMMANDS = []
    for map in LAYER.keys():
        map_keys = map.split("+")
        # if all keys are active, add command to active commands
        if all(map_key in [active_key[0] for active_key in ACTIVE_KEYS] for map_key in map_keys):
            # get value of each key pressed
            map_values = []
            for map_key in map_keys:
                for active_key in ACTIVE_KEYS:
                    if map_key == active_key[0]:
                        map_values.append(active_key[1])
            # use lowest value of all keys
            NEW_ACTIVE_COMMANDS.append({
                "name": LAYER[map], 
                "value": min(map_values),
                "keys": map_keys+[LAYER_ACTIVATION_KEY] if LAYER_ACTIVATION_KEY else map_keys
            })
    return NEW_ACTIVE_COMMANDS

def GET_COMMANDS(AK, doLog=True):
    global MAPPING, ACTIVE_COMMANDS
    ACTIVE_KEYS = AK
    NEW_ACTIVE_COMMANDS = []
    if(len(ACTIVE_KEYS) > 0):
        if doLog: print("")
        if doLog: log("debug", "Active keys:", ACTIVE_KEYS)
    
        try:
            # interpret base layer commands
            if len(ACTIVE_KEYS) > 0:
                NEW_ACTIVE_COMMANDS += INTERPRET_LAYER(ACTIVE_KEYS, MAPPING["BASE"])

            # check whatever layer is active
            LAYERS = []
            if len(ACTIVE_KEYS) > 0:
                for LAYERKEY in MAPPING["LAYERS"].keys():
                    if LAYERKEY in [active_key[0] for active_key in ACTIVE_KEYS]:
                        LAYERS.append([MAPPING["LAYERS"][LAYERKEY], LAYERKEY])
            
            # interpret layers commands
            if len(LAYERS) > 0:
                # avoid log spam
                if doLog: log("", "Active layers:", [LAYER[0] for LAYER in LAYERS])
            for LAYER in LAYERS:
                NEW_ACTIVE_COMMANDS += INTERPRET_LAYER(ACTIVE_KEYS, MAPPING[LAYER[0]], LAYER[1])

            # check for combokey commands and disable single key commands
            if len(NEW_ACTIVE_COMMANDS) > 0:
                for command in NEW_ACTIVE_COMMANDS:
                    if len(command['keys']) > 1: # if command has more than 1 key
                        keys = command['keys']
                        for command2 in NEW_ACTIVE_COMMANDS: # check if other commands keys is a subset of this command keys
                            if command2['name'] != command['name'] and set(command2['keys']).issubset(set(keys)):
                                NEW_ACTIVE_COMMANDS.remove(command2)
                                if doLog: log("debug", "Removed command", command2, "because of", command)
            
            return NEW_ACTIVE_COMMANDS
        except Exception as e:
            # get line and filename of error
            exc_type, exc_obj, exc_tb = sys.exc_info()
            log("error", e, "at line", exc_tb.tb_lineno, "in", os.path.split(exc_tb.tb_frame.f_code.co_filename)[1])
            pass
    else:
        return []

def TRIGGER(COMMANDS, doLog=True, doSeq=True):
    global ACTIVE_COMMANDS
    KEY_USED = []
    try:
        # sort commands by 'keys' key in each items (more keys pressed)
        COMMANDS = sorted(COMMANDS, key=lambda k: len(k['keys']), reverse=True)
        if len(COMMANDS) > 0:
            # avoid log spam
            if doLog: log("debug", "Active commands:")
            for command in COMMANDS:
                if doLog: log("debug", "  -", command)
                    

        # check whatever command needs to be disabled
        if len(ACTIVE_COMMANDS) > 0:
            for command in ACTIVE_COMMANDS: # was active
                # check if command is still active
                if command not in COMMANDS: # not active anymore
                    command['value'] = 0
                    EXECUTE(command, doLog=doLog, doSeq=doSeq)
               
        # check whatever command needs to be enabled
        if len(COMMANDS) > 0:
            for command in COMMANDS:
                EXECUTE(command, doLog=doLog, doSeq=doSeq)
             

        ACTIVE_COMMANDS = COMMANDS
    except Exception as e:
        # get line and filename of error
        exc_type, exc_obj, exc_tb = sys.exc_info()
        log("error", e, "at line", exc_tb.tb_lineno, "in", os.path.split(exc_tb.tb_frame.f_code.co_filename)[1])
        pass
            
def EXECUTE(COMMAND, doLog=True, doSeq=True):
    print("EXECUTE", COMMAND)
    try:
        NAME = COMMAND['name']
        VALUE = COMMAND['value']
        if VALUE <= -AXIS_DEADZONE or VALUE >= AXIS_DEADZONE:
            # avoid log spam
            if doLog: log("", "Executing :", NAME, "with value", VALUE)
        for C in COMMANDS.keys():
            if C == NAME: 
                # found command
                type = COMMANDS[NAME]['type']
                if type == "switch" and VALUE > 0:
                    for relayID in COMMANDS[NAME]['relays']:
                        relay.switch(relayID)
                elif type == "button":
                    for relayID in COMMANDS[NAME]['relays']:
                        if VALUE > 0: 
                            relay.on(relayID)
                        else:
                            relay.off(relayID)
                elif type == "axis":
                    if VALUE > AXIS_DEADZONE:
                        # turn on up relays
                        for relayID in COMMANDS[NAME]['up']:
                            relay.on(relayID)
                        # turn off down relays
                        for relayID in COMMANDS[NAME]['down']:
                            relay.off(relayID)
                            
                    elif VALUE <= -AXIS_DEADZONE:
                        # turn on down relays
                        for relayID in COMMANDS[NAME]['down']:
                            relay.on(relayID)
                        # turn off up relays
                        for relayID in COMMANDS[NAME]['up']:
                            relay.off(relayID)

                    elif VALUE > -AXIS_DEADZONE and VALUE <= AXIS_DEADZONE:
                        # turn off all relays
                        for relayID in COMMANDS[NAME]['up']:
                            relay.off(relayID)
                        for relayID in COMMANDS[NAME]['down']:
                            relay.off(relayID)
                elif type == "arduino":
                    # COMMAND TYPE FOR ARDUINO
                    if COMMANDS[NAME]['name'] == "direction":
                        direction.action(VALUE)
                elif type == "sequence" and doSeq:
                    print("DOING SEQUENCE")
                    try:
                        if VALUE == 1:
                            learn.execute(COMMANDS[NAME]['seqname'])
                    except Exception as e:
                        # get line and filename of error
                        exc_type, exc_obj, exc_tb = sys.exc_info()
                        log("error", e, "at line", exc_tb.tb_lineno, "in", os.path.split(exc_tb.tb_frame.f_code.co_filename)[1])
                        pass
    except Exception as e:
        # get line and filename of error
        exc_type, exc_obj, exc_tb = sys.exc_info()
        log("error", e, "at line", exc_tb.tb_lineno, "in", os.path.split(exc_tb.tb_frame.f_code.co_filename)[1])
        pass