from common import *
import os, bluetooth
import time

# INIT
    

def scan():
    # search for nearby bluetooth devices
    log("", "Scanning for controllers (10s)...")
    nearby_devices = bluetooth.discover_devices(
        lookup_names=True, lookup_class=True)
    gamepads = []
    log("debug", "Found", len(nearby_devices), "devices")
    for device in nearby_devices:
        log("debug", "Check device", device[1], "with class", hex(device[2]))
        if "10100001000" in str(bin(device[2])):
            gamepads.append(device)
    if len(gamepads) > 0:
        log("check", len(gamepads),"controller found(s)")
        return gamepads
    else:
        log("", "Controller not found")
        return []

def getName():
    return checkConnection()

def checkConnection():
    # get name of controller connected
    infos = os.popen("bluetoothctl devices | cut -f2 -d' ' | while read uuid; do bluetoothctl info $uuid; done").read()
    LAST_CONTROLLER_NAME = ""
    for info in infos.split("\n"):
        if "Name:" in info:
            LAST_CONTROLLER_NAME = info.split("Name: ")[1]
        if "Connected: yes" in info:
            return LAST_CONTROLLER_NAME
    return False

def connect(device):
    # connect
    log("", "Connecting to", device[1], "(10s)...")
    os.system("bash /home/lowrider/lowrider_data/pair.sh " + device[0])
    time.sleep(4)
    if checkConnection():
        log("check", "Controller connected")
        return True
    else:
        log("error", "Controller not connected")
        return False