import os, datetime, json

os.environ['PYGAME_HIDE_SUPPORT_PROMPT'] = "hide"
os.environ["SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS"] = "1"
os.environ["SDL_VIDEO_X11_NET_WM_BYPASS_COMPOSITOR"] = "0"
os.environ["SDL_VIDEO_ALLOW_SCREENSAVER"] = "1"


DEBUG_MODE = True
HARDCORE_MODE = True
INPUT_DEADZONE = 0.1
TRIGGER_UPDATE_THRESHOLD = 0.00
AXIS_DEADZONE = 0

def log(level, *msg):
    now = datetime.datetime.now().strftime("%H:%M:%S")
    prefix = "\033[1;96m[INFO / "+now+"]\033[0m"
    if level == "debug":
        if not DEBUG_MODE:
            return
        prefix = "\033[1;93m[DEBUG / "+now+"]\033[0m"
    elif level == "check":
        prefix = "\033[1;92m[CHECK / "+now+"]\033[0m"
    elif level == "error":
        prefix = "\033[1;91m[ERROR / "+now+"]\033[0m"
    elif level == "hardcore":
        if not HARDCORE_MODE:
            return
        prefix = "\033[1;91m[HARDCORE / "+now+"]\033[0m"
    print(prefix, *msg)

