# PIP IMPORTS
import os
import sys
import subprocess
import json
import json
import time
import bluetooth
import pygame.joystick  # for detection
from pyjoystick.sdl2 import Key, Joystick, run_event_loop  # for buttons
# CUSTOM IMPORTS
from common import *
import actions
import bt


DEADMAN_TRIGGER = False
ACTIVE_KEYS = []


def is_connected(doLog=True):
    if doLog:
        log("", "Checking connection to controller...")
    # use pygame to check if controller is connected
    pygame.joystick.quit()
    pygame.joystick.init()
    if (pygame.joystick.get_count() >= 1):
        if doLog:
            log("check", "Gamepad connected (pygame)")
        return True
    else:  # else check if bluetooth is connected
        connection = bt.checkConnection()
        if connection:
            if doLog:
                log("check", "Gamepad connected (bluetooth)")
            return connection
        else:
            if doLog:
                log("error", "Gamepad not connected")
            return connection


def connect():
    # scan
    gamepads = bt.scan()
    for gamepad in gamepads:
        if bt.connect(gamepad):
            return gamepad
    if not is_connected(doLog=False):
        # if no gamepad found, retry
        log("error", "Controller not connected, retrying in 5s...")
        time.sleep(5)
        return connect()
    else:
        return True


def print_add():
    log("check", 'New Gamepad !')


def print_remove():
    log("error", 'Gamepad lost !')
    connect()

# Calculate exactly what keys are pressed


def keyPress(MAPPING, keyCategory, keyName, keyValue, keyActivation, doLog=True, doSeq=True):
    print(keyValue, keyActivation)
    global DEADMAN_TRIGGER, ACTIVE_KEYS
    UPDATE_COMMANDS = False  # if need to update commands
    ALREADY_ACTIVE = keyName in [key[0]
                                 for key in ACTIVE_KEYS]  # if key is already active
    try:
        # DEADMAN SWITCH CHECK
        if MAPPING["DEADMAN"] == keyName:
            if keyActivation and not DEADMAN_TRIGGER:
                DEADMAN_TRIGGER = True
                if doLog:
                    log("", "Deadman armed")
            elif not keyActivation and DEADMAN_TRIGGER:
                DEADMAN_TRIGGER = False
                if doLog:
                    log("", "Deadman desarmed")
                ACTIVE_KEYS = []
                UPDATE_COMMANDS = True
        # IF DEADMAN AND KEY PRESSED IS NOT ALREADY ACTIVE
        elif DEADMAN_TRIGGER and keyActivation and not ALREADY_ACTIVE:  # key activation
            ACTIVE_KEYS.append(
                [keyName, 1 if keyCategory == "Hat" else keyValue])
            if doLog:
                log("hardcore", "Key", keyName, "activated")
            UPDATE_COMMANDS = True
        elif not keyActivation and ALREADY_ACTIVE:  # key deactivation
            ACTIVE_KEYS = [key for key in ACTIVE_KEYS if key[0] != keyName]
            if doLog:
                log("hardcore", "Key", keyName, "deactivated")
            UPDATE_COMMANDS = True
        elif keyActivation and ALREADY_ACTIVE:  # key update
    
            ACTIVE_KEYS = [
                key for key in ACTIVE_KEYS if key[0] != keyName]
            ACTIVE_KEYS.append(
                [keyName, 1 if keyCategory == "Hat" else keyValue])
            if doLog:
                log("hardcore", "Key", keyName, "updated")
            UPDATE_COMMANDS = True
        elif not keyActivation and not ALREADY_ACTIVE:
            if keyName == "DPAD":
                if doLog:
                    log("hardcore", "Key", keyName, "deactivated")
                ACTIVE_KEYS = [
                    key for key in ACTIVE_KEYS if "DPAD" not in key[0]]
                UPDATE_COMMANDS = True

        # MAPPING
        if UPDATE_COMMANDS:
            COMMANDS = actions.GET_COMMANDS(ACTIVE_KEYS, doLog=doLog)
            actions.TRIGGER(COMMANDS, doLog=doLog, doSeq=doSeq)
    except Exception as e:
        # get line and filename of error
        exc_type, exc_obj, exc_tb = sys.exc_info()
        log("error", e, "at line", exc_tb.tb_lineno, "in",
            os.path.split(exc_tb.tb_frame.f_code.co_filename)[1])
        pass


def getName(trials=0, doLog=True):
    if doLog:
        log("", "Getting controller name...")
    pygame.joystick.init()
    if pygame.joystick.get_count() >= 1:
        pygame.joystick.Joystick(0).init()
        if doLog:
            log("check", "Controller name found:",
                pygame.joystick.Joystick(0).get_name())
        return pygame.joystick.Joystick(0).get_name()
    else:
        if trials > 5:
            log("error", "Controller not found")
            return False

        BTname = bt.getName()
        if BTname:
            return BTname
        else:
            time.sleep(.2)
            return getName(trials+1)


def loadLayout():
    global LAYOUT
    # get controller Layout
    controllerName = getName(doLog=False)

    # if controller not in layout, use default
    if controllerName not in LAYOUT:
        # refresh layout
        LAYOUT = json.loads(open(os.path.join(os.path.dirname(
            os.path.abspath(__file__)), "config/controller_layout.json"), "r").read())
        if controllerName not in LAYOUT:
            log("", "Controller not in layout, using default")
            controllerName = "default"
        else:
            log("check", "Controller", controllerName, "is in layout, using it")
    else:
        log("check", "Controller", controllerName, "is in layout, using it")

    return LAYOUT[controllerName]


def getLayout(LAYOUT, key):
    try:
        keyCategory = LAYOUT[key.keytype]
        keyCategoryName = key.keytype
        keyName = keyCategory[str(round(key.value, 2))] if key.keytype == "Hat" else keyCategory[str(key.number)]
        keyValue = round(key.value, 2)
        keyActivation = True if abs(keyValue) > INPUT_DEADZONE else False
        return keyCategoryName, keyName, keyValue, keyActivation
    except Exception as e:
        log("error", "Key", key, "not in layout")
        return False, False, False, False


# global variables
MAPPING = {}
LAYOUT = {}
LAYOUT_REFRESH_RATE = 10
LAST_LAYOUT_REFRESH = 0


def listen(callback=keyPress):
    global MAPPING, LAYOUT, LAST_LAYOUT_REFRESH, LAYOUT_REFRESH_RATE
    log("", "Listening for controller...")
    MAPPING = json.loads(open(os.path.join(os.path.dirname(
        os.path.abspath(__file__)), "config/mapping.json"), "r").read())
    LAYOUT = loadLayout()
    LAST_LAYOUT_REFRESH = time.time()

    def key_received(key):
        global LAYOUT, LAST_LAYOUT_REFRESH, LAYOUT_REFRESH_RATE
        try:
            # in case controller changed
            #if time.time() - LAST_LAYOUT_REFRESH > LAYOUT_REFRESH_RATE:
            #    log("check", "Refreshing controller layout...")
            #    LAYOUT = loadLayout()
            #    LAST_LAYOUT_REFRESH = time.time()
            keyCategory, keyName, keyValue, keyActivation = getLayout(
                LAYOUT, key)
            if keyCategory:
                callback(MAPPING, keyCategory, keyName,
                         keyValue, keyActivation)
        except Exception as e:
            # get line and filename of error
            exc_type, exc_obj, exc_tb = sys.exc_info()
            log("error", e, "at line", exc_tb.tb_lineno, "in",
                os.path.split(exc_tb.tb_frame.f_code.co_filename)[1])
            pass

    run_event_loop(print_add, print_remove, key_received)
    while True:
        time.sleep(7)
        log("info", "Controller still connected ?")
