from common import *
import controller
from pyjoystick.sdl2 import Key, Joystick, run_event_loop  # for buttons
import time


def empty():
    pass


def main():
    log("info", "Welcome to the lowRider mapping mode !")
    # check if controller is connected
    if not controller.is_connected():
        log("error", "Controller not connected")
        return

    print("1. Test Mapping")
    print("2. Reset Mapping")
    choice = int(input("Choose an option : "))
    if choice == 1:
        log("info", "Test mapping")
        testMapping()
    elif choice == 2:
        log("info", "Set mapping for controller:", controller.getName())
        setMapping()


def testMapping():
    log("info", "Testing mapping for controller:", controller.getName())

    def keyPress(MAPPING, keyCategory, keyName, keyValue, keyActivation):
        log("info", "Key", keyName, keyValue, keyActivation)
    controller.listen(keyPress)


CURRENT_TYPE = None
CURRENT_KEY = None
ASSIGNED = {}
ALREADY_ASSIGNED = []
TOASSIGN = []


def setMapping():
    global CURRENT_TYPE, CURRENT_KEY, ASSIGNED
    with open(os.path.join(os.path.dirname(os.path.abspath(__file__)), "config/controller_layout.json"), "r") as file:
        LAYOUT = json.loads(file.read())
        toAssign = LAYOUT["toAssign"]
        for type in toAssign.keys():
            ASSIGNED[type] = {}
            for key in toAssign[type]:
                TOASSIGN.append([type, key])
        changeKey()


def changeKey():
    global CURRENT_TYPE, CURRENT_KEY, ASSIGNED
    if len(TOASSIGN) == 0:
        log("check", "Mapping done !")
        with open(os.path.join(os.path.dirname(os.path.abspath(__file__)), "config/controller_layout.json"), "r") as f:
            LAYOUT = json.loads(f.read())
            LAYOUT[controller.getName()] = ASSIGNED
            f.close()
        with open(os.path.join(os.path.dirname(os.path.abspath(__file__)), "config/controller_layout.json"), "w") as f2:
            f2.write(json.dumps(LAYOUT, indent=4))
            f2.close()
        exit()
    else:
        KEY = TOASSIGN.pop(-1)
        log("info", "Press", KEY[0], KEY[1], "key...")
        CURRENT_TYPE = KEY[0]
        CURRENT_KEY = KEY[1]
        run_event_loop(empty, empty, keyPressAssign)


def keyPressAssign(key):
    global CURRENT_TYPE, CURRENT_KEY, ASSIGNED
    if (abs(key.value) >= 1):
        if key in ALREADY_ASSIGNED:
            log("error", "Key already assigned !")
            return
        log("info", "Key", key, "pressed")
        accept = input("Accept ? (Y/n) : ")
        if accept == "n":
            log("info", "Key", key, "rejected")
            return
        log("check", key, "associated")
        keyID = str(key.number)
        ASSIGNED[CURRENT_TYPE][keyID] = CURRENT_KEY
        ALREADY_ASSIGNED.append(key)
        changeKey()


if __name__ == "__main__":
    main()
