# PIP IMPORTS
import time
import piplates.RELAYplate2 as RELAY2
# CUSTOM IMPORTS
from common import *

BOARD_IDS = [0]
RELAY_IDS = [1, 2, 3, 4, 5, 6, 7, 8]
NUM_RELAY_PER_BOARD = 8

def getComboID(ID):
    if ID <= NUM_RELAY_PER_BOARD:
        return (0, ID)
    elif ID <= NUM_RELAY_PER_BOARD * 2:
        return (1, ID - NUM_RELAY_PER_BOARD)
    else:
        log("error", "Invalid relay ID:", ID)


def on(ID):
    boardID, relayID = getComboID(ID)
    RELAY2.relayON(boardID, relayID)

def off(ID):
    boardID, relayID = getComboID(ID)
    RELAY2.relayOFF(boardID, relayID)

def allOFF():
    for boardID in BOARD_IDS:
        RELAY2.relayALL(boardID, 0)

def switch(ID):
    boardID, relayID = getComboID(ID)
    RELAY2.relayTOGGLE(boardID, relayID)

def test():
    RELAY2.relayON(0, 1)
    RELAY2.relayON(0, 2)
    RELAY2.relayON(0, 3)
    RELAY2.relayON(0, 4)
    RELAY2.relayON(0, 5)
    RELAY2.relayON(0, 6)
    RELAY2.relayON(0, 7)
    time.sleep(3)
    RELAY2.relayOFF(0, 1)
    RELAY2.relayOFF(0, 2)
    RELAY2.relayOFF(0, 3)
    RELAY2.relayOFF(0, 4)
    RELAY2.relayOFF(0, 5)
    RELAY2.relayOFF(0, 6)
    RELAY2.relayOFF(0, 7)

    relays = [0,1]
    for relay in relays:
        for i in range(1,9):
            print("relay", relay, "relay", i)
            RELAY2.relayON(relay, i)
            time.sleep(0.5)
            RELAY2.relayOFF(relay, i)

if __name__ == "__main__":
    test()



allOFF()


